﻿<?xml version="1.0" encoding="utf-8"?>
<pattern id="Content" xmlns="http://purl.oclc.org/dsdl/schematron">
  <title>Content Validations</title>

  <rule context="xbrli:xbrl">
    
    <!-- Rule ID: VR.SS.CMV.000012
      
    IF COUNT(MesageSender:orgname1.xx.xx:OrganisationNameDetails) > 1
      RETURN VALIDATION MESSAGE
    ENDIF
    -->
    <assert id="VR.SS.CMV.000012" diagnostics="DVR.SS.CMV.000012" test="not(
      count(key('contextDetailsById', $RP.MessageSender.ContextId)[self::orgname1.02.00:OrganisationNameDetails]) &gt; 1
    )" />
    
    <!-- Rule ID: VR.SS.CMV.000014
      
    IF COUNT(MessageSender:prsnstrcnm1.xx.xx:PersonNameDetails) > 1
      RETURN VALIDATION MESSAGE
    ENDIF
    -->
    <assert id="VR.SS.CMV.000014" diagnostics="DVR.SS.CMV.000014" test="not(
      count(key('contextDetailsById', $RP.MessageSender.ContextId)[self::prsnstrcnm1.02.00:PersonNameDetails]) &gt; 1
    )" />
    
    <!-- Rule ID: VR.SS.CMV.000016
      
    IF COUNT(MessageSender:email1.xx.xx:ElectronicContactElectronicMail) > 1
      RETURN VALIDATION MESSAGE
    ENDIF
    -->
    <assert id="VR.SS.CMV.000016" diagnostics="DVR.SS.CMV.000016" test="not(
      count(key('contextDetailsById', $RP.MessageSender.ContextId)[self::email1.02.00:ElectronicContactElectronicMail]) &gt; 1
    )" />
    
    <!-- Rule ID: VR.SS.CMV.000018
      
    IF COUNT(MessageSender:phone1.xx.xx:ElectronicContactTelephone) > 1
      RETURN VALIDATION MESSAGE
    ENDIF
    -->
    <assert id="VR.SS.CMV.000018" diagnostics="DVR.SS.CMV.000018" test="not(
      count(key('contextDetailsById', $RP.MessageSender.ContextId)[self::phone1.02.00:ElectronicContactTelephone]) &gt; 1
    )" />
    
    <!-- Rule ID: VR.SS.CMV.000020
      
    IF COUNT(MessageReceiver:orgname1.xx.xx:OrganisationNameDetails) > 1
      RETURN VALIDATION MESSAGE
    ENDIF
    -->
    <assert id="VR.SS.CMV.000020" diagnostics="DVR.SS.CMV.000020" test="not(
      count(key('contextDetailsById', $RP.MessageReceiver.ContextId)[self::orgname1.02.00:OrganisationNameDetails]) &gt; 1
    )" />
    
    <!-- Rule ID: VR.SS.CMV.000022
      
    IF COUNT(Employer:orgname1.xx.xx:OrganisationNameDetails) > 1
      RETURN VALIDATION MESSAGE
    ENDIF
    -->
    <assert id="VR.SS.CMV.000022" diagnostics="DVR.SS.CMV.000022" test="not(
      count(key('contextDetailsById', $RP.Employer.ContextId)[self::orgname1.02.00:OrganisationNameDetails]) &gt; 1
    )" />
    
    <!-- Rule ID: VR.SS.CMV.000024
      
    IF COUNT(SuperFundMember.Any.Any:prsnstrcnm3.xx.xx:PersonNameDetails) > 1
      RETURN VALIDATION MESSAGE
    ENDIF
    -->
    <assert id="VR.SS.CMV.000024" diagnostics="DVR.SS.CMV.000024" test="not(
      count(key('contextDetailsById', $RP.SuperFundMember.ContextId)[self::prsnstrcnm3.02.01:PersonNameDetails]) &gt; 1
    )" />
    
    <!-- Rule ID: VR.SS.CMV.000034
      
    IF COUNT(SuperFundMember.Any.Any:address3.xx.xx:AddressDetails) > 1
      RETURN VALIDATION MESSAGE
    ENDIF
    -->
    <assert id="VR.SS.CMV.000034" diagnostics="DVR.SS.CMV.000034" test="not(
      count(key('contextDetailsById', $RP.SuperFundMember.ContextId)[self::address3.02.01:AddressDetails]) &gt; 1
    )" />
    
    <!-- Rule ID: VR.SS.CMV.000035
      
    IF COUNT(SuperFundMember.Any.Any:email1.xx.xx:ElectronicContactElectronicMail) > 1
      RETURN VALIDATION MESSAGE
    ENDIF
    -->
    <assert id="VR.SS.CMV.000035" diagnostics="DVR.SS.CMV.000035" test="not(
      count(key('contextDetailsById', $RP.SuperFundMember.ContextId)[self::email1.02.00:ElectronicContactElectronicMail]) &gt; 1
    )" />
    
    <!-- Rule ID: VR.SS.CMV.000036
      
    IF COUNT(SuperFundMember.Any.Any:phone1.xx.xx:ElectronicContactTelephone) > 2
      RETURN VALIDATION MESSAGE
    ENDIF
    -->
    <assert id="VR.SS.CMV.000036" diagnostics="DVR.SS.CMV.000036" test="not(
      count(key('contextDetailsById', $RP.SuperFundMember.ContextId)[self::phone1.02.00:ElectronicContactTelephone]) &gt; 2
    )" />
    
    <!-- Rule ID: VR.SS.CMV.000038
      
    IF SuperFundMember.Any.Any:pyid.xx.xx:Identifiers.TaxFileNumberNotProvided.Indicator = FALSE and RprtPyType.xx.xx:SuperFundMember Identifier Scheme = "http://www.sbr.gov.au/id")
      RETURN VALIDATION MESSAGE
    ENDIF
    -->
    <assert id="VR.SS.CMV.000038" diagnostics="DVR.SS.CMV.000038" test="not(
      key('contextDetailsById', $RP.SuperFundMember.ContextId)[self::pyid.02.05:Identifiers.TaxFileNumberNotProvided.Indicator[. = 'false']]
      and
      key('contextById', $RP.SuperFundMember.ContextId)/xbrli:entity/xbrli:identifier[matches(@scheme, '^http://www.sbr.gov.au/id$')]
    )" />
    
    <!-- Rule ID: VR.SS.CMV.000039
      
    IF SuperFundMember.Any.Any:pyid.xx.xx:Identifiers.TaxFileNumberNotProvided.Indicator = TRUE and RprtPyType.xx.xx:SuperFundMember Identifier Scheme = "http://www.ato.gov.au/tfn")
      RETURN VALIDATION MESSAGE
    ENDIF
    -->
    <assert id="VR.SS.CMV.000039" diagnostics="DVR.SS.CMV.000039" test="not(
      key('contextDetailsById', $RP.SuperFundMember.ContextId)[self::pyid.02.05:Identifiers.TaxFileNumberNotProvided.Indicator[. = 'true']]
      and
      key('contextById', $RP.SuperFundMember.ContextId)/xbrli:entity/xbrli:identifier[matches(@scheme, '^http://www.ato.gov.au/tfn$')]
    )" />
    
  </rule>
  
  <rule context="xbrli:xbrl/orgname1.02.00:OrganisationNameDetails[not(@i:nil = 'true')]">
    <let name="thisContextId" value="./*[1]/@contextRef" />
    
    <!-- Rule ID: VR.SS.GEN.000007
      
    WHERE IN TUPLE(orgname1.xx.xx:OrganisationNameDetails)
    IF (OrganisationNameDetails.OrganisationalNameType.Code <> "MN")
      RETURN VALIDATION MESSAGE
    ENDIF
    -->
    <assert id="VR.SS.GEN.000007" diagnostics="DVR.SS.GEN.000007" test="not(
      pyde.02.00:OrganisationNameDetails.OrganisationalNameType.Code[not(. = 'MN')]
    )" />
    
  </rule>
  
  <rule context="xbrli:xbrl/email1.02.00:ElectronicContactElectronicMail[not(@i:nil = 'true')]">
    <let name="thisContextId" value="./*[1]/@contextRef" />
    
    <!-- Rule ID: VR.SS.GEN.000014
      
    WHERE IN TUPLE(email1.xx.xx:ElectronicContactElectronicMail)
    IF (ElectronicContact.ElectronicMail.Usage.Code <> "03")
      RETURN VALIDATION MESSAGE
    ENDIF
    -->
    <assert id="VR.SS.GEN.000014" diagnostics="DVR.SS.GEN.000014" test="not(
      pyde.02.00:ElectronicContact.ElectronicMail.Usage.Code[not(. = '03')]
    )" />
    
  </rule>
  
  <rule context="xbrli:xbrl/phone1.02.00:ElectronicContactTelephone[not(@i:nil = 'true')]">
    <let name="thisContextId" value="./*[1]/@contextRef" />
    
    <!-- Rule ID: VR.SS.GEN.000018
      
    WHERE IN TUPLE(phone1.xx.xx:ElectronicContactTelephone)
    IF (ElectronicContact.Telephone.Usage.Code <> "03")
      RETURN VALIDATION MESSAGE
    ENDIF
    -->
    <assert id="VR.SS.GEN.000018" diagnostics="DVR.SS.GEN.000018" test="not(
      pyde.02.00:ElectronicContact.Telephone.Usage.Code[not(. = '03')]
    )" />
    
    <!-- Rule ID: VR.SS.GEN.000021
      
    WHERE IN TUPLE(phone1.xx.xx:ElectronicContactTelephone)
    IF (ElectronicContact.Telephone.ServiceLine.Code NOT IN SET ("01", "02"))
      RETURN VALIDATION MESSAGE
    ENDIF
    -->
    <assert id="VR.SS.GEN.000021" diagnostics="DVR.SS.GEN.000021" test="not(
      pyde.02.00:ElectronicContact.Telephone.ServiceLine.Code[not(. = '01' or . = '02')]
    )" />
    
  </rule>
  
  <rule context="xbrli:xbrl/prsnstrcnm3.02.01:PersonNameDetails[not(@i:nil = 'true')]">
    <let name="thisContextId" value="./*[1]/@contextRef" />
    
    <!-- Rule ID: VR.SS.CMV.000026
      
    IF SuperFundMember.Any.Any:pyde.xx.xx:PersonNameDetails.PersonNameType.Code <> "LGL"
      RETURN VALIDATION MESSAGE
    ENDIF
    -->
    <assert id="VR.SS.CMV.000026" diagnostics="DVR.SS.CMV.000026" test="not(
      pyde.02.00:PersonNameDetails.PersonNameType.Code[not(. = 'LGL')]
    )" />
    
    <!-- Rule ID: VR.SS.CMV.000028
      
    IF SuperFundMember.Any.Any:pyde.xx.xx:PersonNameDetails.Usage.Code <> "Contact"
      RETURN VALIDATION MESSAGE
    ENDIF
    -->
    <assert id="VR.SS.CMV.000028" diagnostics="DVR.SS.CMV.000028" test="not(
      pyde.02.05:PersonNameDetails.Usage.Code[not(. = 'Contact')]
    )" />
    
    <!-- Rule ID: VR.SS.CMV.000030
      
    IF SuperFundMember.Any.Any:pyde.xx.xx:PersonNameDetails.Currency.Code <> "C"
      RETURN VALIDATION MESSAGE
    ENDIF
    -->
    <assert id="VR.SS.CMV.000030" diagnostics="DVR.SS.CMV.000030" test="not(
      pyde.02.00:PersonNameDetails.Currency.Code[not(. = 'C')]
    )" />
  
  </rule>
  
  <rule context="xbrli:xbrl/address3.02.01:AddressDetails[not(@i:nil = 'true')]">
    <let name="thisContextId" value="./*[1]/@contextRef" />
    
    <!-- Rule ID: VR.SS.GEN.000027
      
    WHERE IN TUPLE (address3.xx.xx:AddressDetails)
    IF (AddressDetails.Usage.Code NOT IN SET ("POS","RES"))
      RETURN VALIDATION MESSAGE
    ENDIF
    -->
    <assert id="VR.SS.GEN.000027" diagnostics="DVR.SS.GEN.000027" test="not(
      pyde.02.01:AddressDetails.Usage.Code[not(. = 'POS' or . = 'RES')]
    )" />
    
    <!-- Rule ID: VR.SS.GEN.000038
      
    WHERE IN TUPLE (address3.xx.xx:AddressDetails)
    IF LENGTH(pyde.xx.xx:AddressDetails.LocalityName.Text) > 50
      RETURN VALIDATION MESSAGE
    ENDIF
    -->
    <assert id="VR.SS.GEN.000038" diagnostics="DVR.SS.GEN.000038" test="not(
      pyde.02.00:AddressDetails.LocalityName.Text[string-length(.) &gt; 50]
    )" />
    
  </rule>
</pattern>